const SiteIdentityIcon = () => {
	return (
		<svg width="36" height="38" viewBox="0 0 36 38" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M36 2C36 0.89543 35.1046 7.8281e-08 34 1.74846e-07L2 2.97237e-06C0.895432 3.06894e-06 7.8281e-08 0.895434 1.74846e-07 2L8.74228e-07 10C9.70792e-07 11.1046 0.895433 12 2 12L34 12C35.1046 12 36 11.1046 36 10L36 2Z" fill="#9835FF" />
			<path opacity="0.2" d="M34.946 2C34.946 1.44772 34.4983 1 33.946 1L2.0001 1C1.44781 1 1.0001 1.44772 1.0001 2L1.0001 36C1.0001 36.5523 1.44781 37 2.0001 37L33.946 37C34.4983 37 34.946 36.5523 34.946 36L34.946 2Z" stroke="#9835FF" strokeWidth="2" />
			<path d="M14.0002 5.5C14.0002 4.11929 12.881 3 11.5002 3L5.50024 3C4.11953 3 3.00024 4.11929 3.00024 5.5C3.00024 6.88071 4.11953 8 5.50024 8L11.5002 8C12.881 8 14.0002 6.88071 14.0002 5.5Z" fill="white" />
			<g opacity="0.4">
				<mask id="path-4-inside-1" fill="white">
					<path d="M21.0002 6C21.0002 5.44772 20.5525 5 20.0002 5L18.0002 5C17.448 5 17.0002 5.44772 17.0002 6C17.0002 6.55228 17.448 7 18.0002 7L20.0002 7C20.5525 7 21.0002 6.55228 21.0002 6Z" />
				</mask>
				<path d="M20.0002 7L18.0002 7L18.0002 3L20.0002 3L20.0002 7ZM18.0002 5L20.0002 5L20.0002 9L18.0002 9L18.0002 5ZM20.0002 5C19.448 5 19.0002 5.44771 19.0002 6L23.0002 6C23.0002 7.65685 21.6571 9 20.0002 9L20.0002 5ZM19.0002 6C19.0002 5.44771 18.5525 5 18.0002 5L18.0002 9C16.3434 9 15.0002 7.65685 15.0002 6L19.0002 6ZM18.0002 7C18.5525 7 19.0002 6.55229 19.0002 6L15.0002 6C15.0002 4.34315 16.3434 3 18.0002 3L18.0002 7ZM20.0002 3C21.6571 3 23.0002 4.34315 23.0002 6L19.0002 6C19.0002 6.55229 19.448 7 20.0002 7L20.0002 3Z" fill="white" mask="url(#path-4-inside-1)" />
			</g>
			<g opacity="0.4">
				<mask id="path-6-inside-2" fill="white">
					<path d="M27.0002 6C27.0002 5.44772 26.5525 5 26.0002 5L24.0002 5C23.448 5 23.0002 5.44772 23.0002 6C23.0002 6.55228 23.448 7 24.0002 7L26.0002 7C26.5525 7 27.0002 6.55228 27.0002 6Z" />
				</mask>
				<path d="M26.0002 7L24.0002 7L24.0002 3L26.0002 3L26.0002 7ZM24.0002 5L26.0002 5L26.0002 9L24.0002 9L24.0002 5ZM26.0002 5C25.448 5 25.0002 5.44771 25.0002 6L29.0002 6C29.0002 7.65685 27.6571 9 26.0002 9L26.0002 5ZM25.0002 6C25.0002 5.44771 24.5525 5 24.0002 5L24.0002 9C22.3434 9 21.0002 7.65685 21.0002 6L25.0002 6ZM24.0002 7C24.5525 7 25.0002 6.55229 25.0002 6L21.0002 6C21.0002 4.34315 22.3434 3 24.0002 3L24.0002 7ZM26.0002 3C27.6571 3 29.0002 4.34315 29.0002 6L25.0002 6C25.0002 6.55229 25.448 7 26.0002 7L26.0002 3Z" fill="white" mask="url(#path-6-inside-2)" />
			</g>
			<g opacity="0.4">
				<mask id="path-8-inside-3" fill="white">
					<path d="M33.0002 6C33.0002 5.44772 32.5525 5 32.0002 5L30.0002 5C29.448 5 29.0002 5.44772 29.0002 6C29.0002 6.55228 29.448 7 30.0002 7L32.0002 7C32.5525 7 33.0002 6.55228 33.0002 6Z" />
				</mask>
				<path d="M32.0002 7L30.0002 7L30.0002 3L32.0002 3L32.0002 7ZM30.0002 5L32.0002 5L32.0002 9L30.0002 9L30.0002 5ZM32.0002 5C31.448 5 31.0002 5.44771 31.0002 6L35.0002 6C35.0002 7.65685 33.6571 9 32.0002 9L32.0002 5ZM31.0002 6C31.0002 5.44771 30.5525 5 30.0002 5L30.0002 9C28.3434 9 27.0002 7.65685 27.0002 6L31.0002 6ZM30.0002 7C30.5525 7 31.0002 6.55229 31.0002 6L27.0002 6C27.0002 4.34315 28.3434 3 30.0002 3L30.0002 7ZM32.0002 3C33.6571 3 35.0002 4.34315 35.0002 6L31.0002 6C31.0002 6.55229 31.448 7 32.0002 7L32.0002 3Z" fill="white" mask="url(#path-8-inside-3)" />
			</g>
		</svg>
	);
}

const ColorSettingsIcon = () => {
	return (
		<svg width="38" height="39" viewBox="0 0 38 39" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path opacity="0.9" d="M18.8137 0C8.36166 0 0 8.52889 0 19.19C0 29.8511 8.36166 38.38 18.8137 38.38C19.4409 38.38 20.068 38.38 20.6951 38.38C22.7855 38.1668 24.8759 37.5271 26.5483 36.6742C27.8025 36.0346 28.4296 35.3949 28.8477 34.542C29.0568 33.9023 29.0568 33.2627 28.8477 32.8362C28.8477 32.8362 28.8477 32.623 28.8477 32.4098C28.0116 29.8511 25.085 29.8511 25.085 29.8511C25.085 29.8511 20.9041 29.8511 20.9041 25.5867C20.9041 21.3222 25.085 21.3222 25.085 21.3222H33.4466C33.4466 21.3222 37.4184 21.3222 37.4184 17.0578C36.3732 7.46278 28.4296 0 18.8137 0ZM9.40686 25.5867C7.73453 25.5867 6.27124 24.0941 6.27124 22.3883C6.27124 20.6826 7.73453 19.19 9.40686 19.19C11.0792 19.19 12.5425 20.6826 12.5425 22.3883C12.5425 24.0941 11.0792 25.5867 9.40686 25.5867ZM13.5877 14.9256C11.9154 14.9256 10.4521 13.433 10.4521 11.7272C10.4521 10.0214 11.9154 8.52889 13.5877 8.52889C15.26 8.52889 16.7233 10.0214 16.7233 11.7272C16.7233 13.433 15.26 14.9256 13.5877 14.9256ZM24.0398 12.7933C22.3674 12.7933 20.9041 11.3008 20.9041 9.595C20.9041 7.88922 22.3674 6.39667 24.0398 6.39667C25.7121 6.39667 27.1754 7.88922 27.1754 9.595C27.1754 11.3008 25.7121 12.7933 24.0398 12.7933Z" fill="#335AFF" />
			<path d="M24.0394 12.7934C25.7712 12.7934 27.175 11.3615 27.175 9.59506C27.175 7.82867 25.7712 6.39673 24.0394 6.39673C22.3077 6.39673 20.9038 7.82867 20.9038 9.59506C20.9038 11.3615 22.3077 12.7934 24.0394 12.7934Z" fill="#FFDA2B" />
			<path d="M9.40662 25.5869C11.1384 25.5869 12.5422 24.1549 12.5422 22.3885C12.5422 20.6221 11.1384 19.1902 9.40662 19.1902C7.67486 19.1902 6.271 20.6221 6.271 22.3885C6.271 24.1549 7.67486 25.5869 9.40662 25.5869Z" fill="#EC3972" />
		</svg>
	);
}

const TypographySettingsIcon = () => {
	return (
		<svg width="34" height="36" viewBox="0 0 34 36" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0 1.8V7.8C0 8.27739 0.190489 8.73523 0.529561 9.07279C0.868634 9.41036 1.32851 9.6 1.80804 9.6H12.0536V34.2C12.0536 34.6774 12.2441 35.1352 12.5831 35.4728C12.9222 35.8104 13.3821 36 13.8616 36H19.929C20.4014 36 20.8551 35.8159 21.1929 35.4872C21.5307 35.1584 21.7259 34.7111 21.7366 34.2409L21.847 29.4067L15.7556 14.2459C15.6668 14.0251 15.646 13.7831 15.6956 13.5505C15.7453 13.3179 15.8632 13.1052 16.0345 12.9395C16.2058 12.7738 16.4226 12.6624 16.6576 12.6196C16.8925 12.5768 17.1349 12.6044 17.3541 12.699L22.1808 14.7813L22.2991 9.6H31.942C32.4215 9.6 32.8814 9.41036 33.2204 9.07279C33.5595 8.73523 33.75 8.27739 33.75 7.8V1.8C33.75 1.32261 33.5595 0.864773 33.2204 0.527208C32.8814 0.189642 32.4215 0 31.942 0H1.80804C1.32851 0 0.868634 0.189642 0.529561 0.527208C0.190489 0.864773 0 1.32261 0 1.8Z" fill="#476BFF" />
			<path d="M24.6644 29.9658L26.6089 23.6532L33.2691 22.3295C33.3951 22.3044 33.5094 22.2429 33.5953 22.1537C33.6812 22.0646 33.7343 21.9524 33.747 21.8335C33.7598 21.7145 33.7314 21.5948 33.6661 21.4918C33.6007 21.3887 33.5018 21.3075 33.3835 21.26L16.875 14.625L23.5145 30.0203C23.5617 30.1296 23.6444 30.2224 23.7513 30.2859C23.8582 30.3494 23.9837 30.3803 24.1105 30.3743C24.2372 30.3683 24.3587 30.3256 24.458 30.2524C24.5574 30.1791 24.6295 30.0789 24.6644 29.9658Z" fill="#9835FF" />
		</svg>
	);
}

const LayoutSettingsIcon = () => {
	return (
		<svg width="38" height="38" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M38.0001 22.7999V36.0999C38.0001 37.0499 37.0501 37.9999 36.1001 37.9999H28.5001C27.5501 37.9999 26.6001 37.0499 26.6001 36.0999V22.7999C26.6001 21.8499 27.5501 20.8999 28.5001 20.8999H36.1001C37.0501 20.8999 38.0001 21.8499 38.0001 22.7999Z" fill="#9835FF" />
			<path d="M24.7 22.7999V36.0999C24.7 37.0499 23.75 37.9999 22.8 37.9999H15.2C14.25 37.9999 13.3 37.0499 13.3 36.0999V22.7999C13.3 21.8499 14.25 20.8999 15.2 20.8999H22.8C23.75 20.8999 24.7 21.8499 24.7 22.7999Z" fill="#FFDA2B" />
			<path d="M11.4 22.7999V36.0999C11.4 37.0499 10.45 37.9999 9.5 37.9999H1.9C0.95 37.9999 0 37.0499 0 36.0999V22.7999C0 21.8499 0.95 20.8999 1.9 20.8999H9.5C10.45 20.8999 11.4 21.8499 11.4 22.7999Z" fill="#0099FF" />
			<path d="M38 1.9V17.1C38 18.05 37.05 19 36.1 19H1.9C0.95 19 0 18.05 0 17.1V1.9C0 0.95 0.95 0 1.9 0H36.1C37.05 0 38 0.95 38 1.9Z" fill="#FFDA2B" />
		</svg>
	);
}

const HeaderBuilderIcon = () => {
	return (
		<svg width="36" height="38" viewBox="0 0 36 38" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path opacity="0.3" d="M34.9458 2C34.9458 1.44772 34.4981 1 33.9458 1L1.99986 1C1.44757 1 0.999851 1.44772 0.999851 2L0.999854 36C0.999854 36.5523 1.44757 37 1.99985 37L33.9458 37C34.4981 37 34.9458 36.5523 34.9458 36L34.9458 2Z" stroke="#FE7831" strokeWidth="2" />
			<path d="M34.9458 2C34.9458 1.44772 34.4981 1 33.9458 1L2.47913 1C1.92685 1 1.47913 1.44772 1.47913 2L1.47913 9.93333C1.47913 10.4856 1.92685 10.9333 2.47913 10.9333L33.9458 10.9333C34.4981 10.9333 34.9458 10.4856 34.9458 9.93333L34.9458 2Z" stroke="#FE7831" strokeWidth="2" />
			<path d="M12 6C12 4.89543 11.1046 4 10 4L7 4C5.89543 4 5 4.89543 5 6C5 7.10457 5.89543 8 7 8L10 8C11.1046 8 12 7.10457 12 6Z" fill="#FE7831" />
			<path d="M20 6C20 5.44772 19.5523 5 19 5L17 5C16.4477 5 16 5.44772 16 6C16 6.55228 16.4477 7 17 7L19 7C19.5523 7 20 6.55228 20 6Z" fill="#FE7831" />
			<path d="M26 6C26 5.44772 25.5523 5 25 5L23 5C22.4477 5 22 5.44772 22 6C22 6.55228 22.4477 7 23 7L25 7C25.5523 7 26 6.55228 26 6Z" fill="#FE7831" />
			<path d="M32 6C32 5.44772 31.5523 5 31 5L29 5C28.4477 5 28 5.44772 28 6C28 6.55228 28.4477 7 29 7L31 7C31.5523 7 32 6.55228 32 6Z" fill="#FE7831" />
		</svg>
	);
}

const BlogSettingsIcon = () => {
	return (
		<svg width="41" height="32" viewBox="0 0 41 32" fill="none" xmlns="http://www.w3.org/2000/svg">
			<rect width="40.35" height="4.87352" rx="2.43676" fill="#00BE82" />
			<rect opacity="0.7" y="16.0552" width="33.8537" height="2.24081" fill="#00BE82" />
			<rect opacity="0.7" y="22.7659" width="35.8785" height="2.24081" fill="#00BE82" />
			<rect opacity="0.7" y="29.4766" width="24.3132" height="2.24081" fill="#00BE82" />
			<rect opacity="0.7" y="9.34448" width="36.3414" height="2.24081" fill="#00BE82" />
		</svg>
	);
}

const PageSettingsIcon = () => {
	return (
		<svg width="36" height="38" viewBox="0 0 36 38" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M34.4666 2C34.4666 1.44771 34.0188 1 33.4666 1L1.99989 1C1.44761 1 0.99989 1.44772 0.99989 2L0.999893 36C0.999893 36.5523 1.44761 37 1.99989 37L33.4666 37C34.0188 37 34.4666 36.5523 34.4666 36L34.4666 2Z" stroke="#F04B6A" strokeWidth="2" />
			<path opacity="0.2" d="M30.3999 7.6001L5.06657 7.6001L5.06657 21.5334L30.3999 21.5334L30.3999 7.6001Z" fill="#F04B6A" />
			<path d="M27.8667 20.2667L21.6741 12.6667L17.7334 16.7201L13.5879 14.6935L7.60004 20.2667L27.8667 20.2667Z" fill="#F04B6A" />
			<path d="M26.7261 25.3333L5.06648 25.3333L5.06648 26.5999L26.7261 26.5999L26.7261 25.3333Z" fill="#F04B6A" />
			<path d="M29.1333 27.8667L5.06708 27.8667L5.06708 29.1334L29.1333 29.1334L29.1333 27.8667Z" fill="#F04B6A" />
			<path d="M24.3203 30.3999L5.06734 30.3999L5.06734 31.6666L24.3203 31.6666L24.3203 30.3999Z" fill="#F04B6A" />
			<circle cx="18.3666" cy="10.7667" r="1.9" fill="#F04B6A" />
		</svg>
	);
}

const SidebarSettingsIcon = () => {
	return (
		<svg width="36" height="38" viewBox="0 0 36 38" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1 36C1 36.5523 1.44771 37 2 37H33.9459C34.4982 37 34.9459 36.5523 34.9459 36V2C34.9459 1.44772 34.4982 1 33.9459 1H2C1.44772 1 1 1.44772 1 2V36Z" stroke="#5164F5" strokeWidth="2" />
			<path d="M21.2666 36C21.2666 36.5523 21.7143 37 22.2666 37H33.4666C34.0189 37 34.4666 36.5523 34.4666 36V2C34.4666 1.44772 34.0189 1 33.4666 1H22.2666C21.7143 1 21.2666 1.44772 21.2666 2V36Z" stroke="#5164F5" strokeWidth="2" />
			<path d="M25.0667 11.4001C25.0667 11.5474 25.186 11.6667 25.3333 11.6667H30.4C30.5473 11.6667 30.6667 11.5474 30.6667 11.4001C30.6667 11.2528 30.5473 11.1334 30.4 11.1334H25.3333C25.186 11.1334 25.0667 11.2528 25.0667 11.4001Z" stroke="#9835FF" strokeWidth="2" />
			<path d="M25.0667 16.4667C25.0667 16.614 25.186 16.7334 25.3333 16.7334H30.4C30.5473 16.7334 30.6667 16.614 30.6667 16.4667C30.6667 16.3195 30.5473 16.2001 30.4 16.2001H25.3333C25.186 16.2001 25.0667 16.3195 25.0667 16.4667Z" stroke="#9835FF" strokeWidth="2" />
			<path d="M25.0667 21.5334C25.0667 21.6807 25.186 21.8 25.3333 21.8H30.4C30.5473 21.8 30.6667 21.6807 30.6667 21.5334C30.6667 21.3861 30.5473 21.2667 30.4 21.2667H25.3333C25.186 21.2667 25.0667 21.3861 25.0667 21.5334Z" stroke="#9835FF" strokeWidth="2" />
		</svg>
	);
}

const FooterBuilderIcon = () => {
	return (
		<svg width="36" height="38" viewBox="0 0 36 38" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1 36C1 36.5523 1.44771 37 2 37H33.9459C34.4982 37 34.9459 36.5523 34.9459 36V2C34.9459 1.44772 34.4982 1 33.9459 1H2C1.44772 1 1 1.44772 1 2V36Z" stroke="#0099FF" strokeWidth="2" />
			<path d="M1 36C1 36.5523 1.44772 37 2 37H33.4667C34.019 37 34.4667 36.5523 34.4667 36V26.0667C34.4667 25.5144 34.019 25.0667 33.4667 25.0667H2C1.44771 25.0667 1 25.5144 1 26.0667V36Z" stroke="#0099FF" strokeWidth="2" />
			<path d="M17.4666 36.7333C17.4666 36.8806 17.5859 37 17.7332 37C17.8805 37 17.9999 36.8806 17.9999 36.7333V26.4944C17.9999 26.3472 17.8805 26.2278 17.7332 26.2278C17.5859 26.2278 17.4666 26.3472 17.4666 26.4944V36.7333Z" stroke="#0099FF" strokeWidth="2" />
		</svg>
	);
}

const RightArrow = () => {
	return (
		<svg width="19" height="11" viewBox="0 0 19 11" fill="none" xmlns="http://www.w3.org/2000/svg" className="rightArrow">
			<g>
				<path d="M16.0159 5.44446H1" stroke="" strokeWidth="2" strokeLinecap="round" />
				<path d="M12.5554 1L16.9999 5.44444L12.5554 9.88889" stroke="" strokeWidth="2" strokeLinecap="round" />
			</g>
		</svg>

	);
}

const DocumentIcon = () => {
	return (
		<svg width="17" height="19" viewBox="0 0 17 19" fill="none" xmlns="http://www.w3.org/2000/svg" className="document">
			<path d="M11.5681 18.5C14.4601 18.5 16.1922 16.7437 16.2 13.8113V5.18874C16.2 2.25629 14.4758 0.5 11.5759 0.5H9.00523C8.67555 0.53686 8.42601 0.819319 8.42601 1.15563C8.42601 1.49194 8.67555 1.7744 9.00523 1.81126H11.5681C13.7782 1.81126 14.8911 2.94768 14.8911 5.18874V13.8113C14.8911 16.0523 13.7782 17.1887 11.5681 17.1887H4.62409C2.41393 17.1887 1.29318 16.0523 1.29318 13.8113V5.18874C1.29318 2.94768 2.41393 1.81126 4.62409 1.81126C4.95377 1.7744 5.20331 1.49194 5.20331 1.15563C5.20331 0.819319 4.95377 0.53686 4.62409 0.5C1.73208 0.5 0 2.25629 0 5.18874V13.8113C0 16.7517 1.73208 18.5 4.62409 18.5H11.5681ZM11.3329 6.34106C11.6879 6.34106 11.9756 6.0493 11.9756 5.6894C11.9756 5.3295 11.6879 5.03775 11.3329 5.03775H4.84354C4.4886 5.03775 4.20087 5.3295 4.20087 5.6894C4.20087 6.0493 4.4886 6.34106 4.84354 6.34106H11.3329ZM11.3329 10.1556C11.5809 10.1834 11.8227 10.0648 11.9553 9.85049C12.0879 9.63616 12.0879 9.36384 11.9553 9.14951C11.8227 8.93519 11.5809 8.81664 11.3329 8.84437H4.84354C4.51387 8.88123 4.26433 9.16369 4.26433 9.5C4.26433 9.83631 4.51387 10.1188 4.84354 10.1556H11.3329ZM7.32017 13.9623C7.64985 13.9254 7.89939 13.6429 7.89939 13.3066C7.89939 12.9703 7.64985 12.6879 7.32017 12.651H4.85138C4.5217 12.6879 4.27217 12.9703 4.27217 13.3066C4.27217 13.6429 4.5217 13.9254 4.85138 13.9623H7.32017Z" stroke="none"/>
		</svg>
	);
}

const RightIcon = () => {
	return (
		<svg width="8" height="12" viewBox="0 0 8 12" fill="none" xmlns="http://www.w3.org/2000/svg" className="rightIcon">
			<path opacity="0.8" d="M1.15589 11.3441C0.966931 11.1551 0.949753 10.8594 1.10436 10.6511L1.15589 10.5914L5.74703 6L1.15589 1.40862C0.966931 1.21966 0.949753 0.923961 1.10436 0.715592L1.15589 0.655895C1.34486 0.466932 1.64056 0.449753 1.84892 0.60436L1.90862 0.655895L6.87636 5.62364C7.06533 5.8126 7.08251 6.1083 6.9279 6.31667L6.87636 6.37636L1.90862 11.3441C1.70076 11.552 1.36375 11.552 1.15589 11.3441Z" />
		</svg>
	);
}

const VideoIcon = () => {
	return (
		<svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" className="videoIcon">
			<path d="M7.54126 13.3988L13.6899 9.6323L7.54126 5.86578V13.3988Z" fill="#307AC9" />
			<path d="M9.5 0C7.62108 0 5.78435 0.557165 4.22209 1.60104C2.65982 2.64491 1.44218 4.12861 0.723149 5.86451C0.00411619 7.6004 -0.184015 9.51054 0.182544 11.3534C0.549104 13.1962 1.45389 14.8889 2.78249 16.2175C4.11109 17.5461 5.80383 18.4509 7.64664 18.8175C9.48946 19.184 11.3996 18.9959 13.1355 18.2769C14.8714 17.5578 16.3551 16.3402 17.399 14.7779C18.4428 13.2156 19 11.3789 19 9.5C19 6.98044 17.9991 4.56408 16.2175 2.78249C14.4359 1.00089 12.0196 0 9.5 0V0ZM9.5 17.67C7.88413 17.67 6.30454 17.1908 4.96099 16.2931C3.61744 15.3954 2.57028 14.1194 1.95191 12.6265C1.33354 11.1336 1.17175 9.49093 1.48699 7.90611C1.80223 6.32129 2.58035 4.86553 3.72294 3.72294C4.86554 2.58034 6.32129 1.80223 7.90611 1.48698C9.49094 1.17174 11.1337 1.33354 12.6265 1.9519C14.1194 2.57027 15.3954 3.61744 16.2931 4.96099C17.1908 6.30454 17.67 7.88412 17.67 9.5C17.67 11.6668 16.8092 13.7449 15.2771 15.2771C13.7449 16.8092 11.6668 17.67 9.5 17.67Z" fill="#307AC9" />
		</svg>
	);
}

const SupportIcon = () => {
	return (
		<svg width="24" height="19" viewBox="0 0 24 19" fill="none" xmlns="http://www.w3.org/2000/svg" className="supportIcon">
			<path d="M4.55679 12.4885C4.52212 12.4885 4.48744 12.4806 4.45502 12.4649C4.37622 12.4261 4.32623 12.346 4.32623 12.2579V10.6348C4.32623 10.3252 3.16553 10.0733 2.85347 10.0733H2.03571C1.46472 10.0733 1 9.60675 1 9.03328V2.03571C1 1.46472 1.46472 1 2.03571 1H14.4622C15.0359 1 15.5024 1.46472 15.5024 2.03571V6.74211C15.5024 6.86955 15.3993 6.97267 15.2719 6.97267H11.0237C10.7067 6.97267 10.4491 7.23227 10.4491 7.55154V9.84271C10.4491 9.97015 10.346 10.0733 10.2185 10.0733H7.94852C7.82018 10.0733 7.7031 10.1131 7.61033 10.1885L4.69774 12.4403C4.65676 12.4721 4.60678 12.4885 4.55679 12.4885ZM2.03571 1.46112C1.71869 1.46112 1.46112 1.71892 1.46112 2.03571V9.03328C1.46112 9.35255 1.71869 9.61215 2.03571 9.61215H2.85347C3.41996 9.61215 4.78735 10.071 4.78735 10.6348V11.7883L7.32394 9.82717C7.4928 9.68983 7.71616 9.61215 7.94852 9.61215H9.98796V7.55154C9.98796 6.97807 10.4527 6.51155 11.0237 6.51155H15.0413V2.03571C15.0413 1.71892 14.7815 1.46112 14.4622 1.46112H2.03571Z" strokeWidth="0.75" />
			<path d="M20.9292 18C20.8792 18 20.8292 17.9835 20.7882 17.9518L17.8846 15.7036C17.7842 15.6275 17.6599 15.5847 17.5375 15.5847H11.0237C10.4528 15.5847 9.98804 15.12 9.98804 14.549V7.55146C9.98804 6.97799 10.4528 6.51147 11.0237 6.51147H22.5435C23.1145 6.51147 23.5792 6.97799 23.5792 7.55146V14.549C23.5792 15.12 23.1145 15.5847 22.5435 15.5847H21.7258C21.4191 15.5847 21.1597 15.8439 21.1597 16.1508V17.7694C21.1597 17.8574 21.1098 17.9376 21.0305 17.9763C20.9985 17.9923 20.9639 18 20.9292 18ZM11.0237 6.97259C10.7067 6.97259 10.4492 7.23219 10.4492 7.55146V14.549C10.4492 14.8658 10.7067 15.1236 11.0237 15.1236H17.5375C17.7599 15.1236 17.9828 15.1995 18.1647 15.3375L20.6986 17.2993V16.1508C20.6986 15.5845 21.1593 15.1236 21.7258 15.1236H22.5435C22.8606 15.1236 23.1181 14.8658 23.1181 14.549V7.55146C23.1181 7.23219 22.8606 6.97259 22.5435 6.97259H11.0237Z" strokeWidth="0.5" />
			<g opacity="0.7">
				<path d="M6.68782 7.4381C6.57686 7.4381 6.48707 7.34831 6.48707 7.23735V6.57764C6.48707 6.12595 6.73095 5.71483 7.10815 5.53055C7.51162 5.33332 7.72257 4.88476 7.62101 4.43973C7.54259 4.09684 7.2595 3.81375 6.91642 3.73533C6.62156 3.66907 6.32082 3.73474 6.09066 3.91785C5.86089 4.10116 5.72914 4.37464 5.72914 4.66833C5.72914 4.77929 5.63935 4.86908 5.52839 4.86908C5.41743 4.86908 5.32764 4.77929 5.32764 4.66833C5.32764 4.25172 5.51467 3.86394 5.8405 3.60398C6.16633 3.34421 6.58941 3.24893 7.00581 3.34402C7.50378 3.45753 7.89862 3.85257 8.01233 4.35033C8.15544 4.97808 7.85627 5.61171 7.28459 5.89128C7.04385 6.00871 6.88858 6.27828 6.88858 6.57764V7.23735C6.88858 7.34831 6.79879 7.4381 6.68782 7.4381Z" strokeWidth="0.75" />
				<path d="M6.6883 8.48936C6.63184 8.48936 6.58361 8.46525 6.54362 8.42917C6.50755 8.38898 6.48755 8.34076 6.48755 8.28861C6.48755 8.23646 6.50755 8.18431 6.54362 8.14804C6.624 8.06786 6.75221 8.06786 6.82867 8.14412C6.86867 8.18431 6.88906 8.23646 6.88906 8.28861C6.88906 8.34076 6.86867 8.3931 6.82867 8.42917C6.7926 8.46525 6.74045 8.48936 6.6883 8.48936Z" strokeWidth="0.75" />
			</g>
			<path opacity="0.7" d="M20.7093 10.4495H12.8578C12.7303 10.4495 12.6272 10.3464 12.6272 10.219C12.6272 10.0915 12.7303 9.9884 12.8578 9.9884H20.7093C20.8368 9.9884 20.9399 10.0915 20.9399 10.219C20.9399 10.3464 20.8368 10.4495 20.7093 10.4495Z" strokeWidth="0.75" />
			<g opacity="0.7">
				<path d="M18.3891 12.8796H12.8575C12.7301 12.8796 12.627 12.7765 12.627 12.649C12.627 12.5216 12.7301 12.4185 12.8575 12.4185H18.3891C18.5165 12.4185 18.6197 12.5216 18.6197 12.649C18.6197 12.7765 18.5165 12.8796 18.3891 12.8796Z" strokeWidth="0.75" />
			</g>
		</svg>
	);
}

const SupportLink = () => {
	return (
		'https://rishitheme.com/support/'
	);
}

export {
	SiteIdentityIcon,
	ColorSettingsIcon,
	TypographySettingsIcon,
	LayoutSettingsIcon,
	HeaderBuilderIcon,
	BlogSettingsIcon,
	PageSettingsIcon,
	SidebarSettingsIcon,
	FooterBuilderIcon,
	RightArrow,
	DocumentIcon,
	RightIcon,
	VideoIcon,
	SupportIcon,
	SupportLink
};
