<?php

/**
 * Inline SVG
 *
 * @package Rishi_Theme
 * @since 1.0.0
 */
if (!function_exists('rishi__cb_customizer_image_picker_file')) {
	function rishi__cb_customizer_image_picker_file( $path )
	{
		$svgs = [
			// cart icons
			'cart-1' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.41665 6.16665C6.41665 3.17513 8.8418 0.75 11.8333 0.75C14.8249 0.75 17.25 3.17513 17.25 6.16665V7.75H20C20.39 7.75 20.715 8.049 20.7474 8.4377L21.9141 22.4377C21.9315 22.6468 21.8606 22.8535 21.7186 23.0079C21.5765 23.1622 21.3764 23.25 21.1666 23.25H2.5C2.29026 23.25 2.0901 23.1622 1.94809 23.0079C1.80607 22.8535 1.73517 22.6468 1.75259 22.4377L2.91926 8.4377C2.95165 8.049 3.2766 7.75 3.66667 7.75H6.41665V6.16665ZM15.75 7.75H7.91665V6.16665C7.91665 4.00355 9.6702 2.25 11.8333 2.25C13.9964 2.25 15.75 4.00355 15.75 6.16665V7.75Z" fill="#566779"/></svg>
			',

			'cart-2' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18 18C16.9038 18 16 18.8846 16 20C16 21.0962 16.8846 22 18 22C19.0962 22 20 21.1154 20 20C19.9808 18.9038 19.0962 18 18 18Z" fill="#566779"/><path d="M21.2662 5.36093C21.2212 5.36093 21.1539 5.33775 21.0865 5.33775H6.94004L6.71549 3.78477C6.58076 2.7649 5.72748 2 4.71702 2H3C2.5 2 2 2.5 2 3C2 3.5 2.5 4 3 4C3 4 4.60475 4 4.71702 4C4.8293 4 4.91911 4.09272 4.94157 4.20861C4.96402 4.3245 6.33376 13.8444 6.33376 13.8444C6.5134 15.0728 7.54632 16 8.75887 16H18.1C19.2677 16 20.2781 15.1424 20.5252 13.9603L21.9847 6.42715C22.0745 5.9404 21.7602 5.45364 21.2662 5.36093Z" fill="#566779"/><path d="M8.96972 18C7.82803 18.058 6.96192 18.9855 7.00129 20.087C7.04066 21.1498 7.92645 22 9.00909 22H9.04846C10.1705 21.942 11.0563 21.0145 10.9972 19.913C10.9578 18.8502 10.0524 18 8.96972 18Z" fill="#566779"/></svg>
			',

			'cart-3' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M1.46398 9.50757C1.16228 9.50757 0.9409 9.79112 1.01408 10.0838L3.94062 21.79C4.04385 22.2029 4.41483 22.4926 4.84044 22.4926H19.1595C19.5851 22.4926 19.9561 22.2029 20.0593 21.79L22.9859 10.0838C23.0591 9.79112 22.8377 9.50757 22.536 9.50757H1.46398ZM12 13.6813C10.7194 13.6813 9.68125 14.7195 9.68125 16.0001C9.68125 17.2807 10.7194 18.3188 12 18.3188C13.2806 18.3188 14.3187 17.2807 14.3187 16.0001C14.3187 14.7195 13.2806 13.6813 12 13.6813Z" fill="#566779"/><path d="M18.5 10.5L13.5887 4.07758C12.7882 3.03078 11.2118 3.03078 10.4113 4.07758L5.5 10.5" stroke="#566779" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/></svg>
			',

			// trigger icons
			'trigger-1' => '<svg width="100%" viewBox="0 0 100 70"><path d="M61.2,36.2H38.8c-0.7,0-1.2-0.6-1.2-1.2l0,0c0-0.7,0.6-1.2,1.2-1.2h22.5c0.7,0,1.2,0.6,1.2,1.2l0,0C62.5,35.7,61.9,36.2,61.2,36.2z M62.5,44L62.5,44c0-0.7-0.6-1.2-1.2-1.2H38.8c-0.7,0-1.2,0.6-1.2,1.2l0,0c0,0.7,0.6,1.2,1.2,1.2h22.5C61.9,45.3,62.5,44.7,62.5,44z M62.5,26L62.5,26c0-0.7-0.6-1.3-1.2-1.3H38.8c-0.7,0-1.2,0.6-1.2,1.2v0c0,0.7,0.6,1.2,1.2,1.2h22.5C61.9,27.2,62.5,26.7,62.5,26z" fill="#566779"></svg>
			',

			'trigger-2' => '<svg width="100%" viewBox="0 0 100 70"><path d="M61.2,36.2H38.8c-0.7,0-1.2-0.6-1.2-1.2l0,0c0-0.7,0.6-1.2,1.2-1.2h22.5c0.7,0,1.2,0.6,1.2,1.2l0,0C62.5,35.7,61.9,36.2,61.2,36.2z M56.3,43L56.3,43c0-0.7-0.6-1.3-1.2-1.3H38.8c-0.7,0-1.2,0.6-1.2,1.2v0c0,0.7,0.6,1.2,1.2,1.2H55C55.7,44.3,56.3,43.7,56.3,43z M50,27L50,27c0-0.7-0.6-1.2-1.2-1.2h-10c-0.7,0-1.2,0.6-1.2,1.2v0c0,0.7,0.6,1.2,1.2,1.2h10C49.4,28.2,50,27.7,50,27z" fill="#566779"></svg>
			',

			'trigger-3' => '<svg xmlns="http://www.w3.org/2000/svg" width="20.5" height="16" viewBox="0 0 20.5 16"><g id="Group_45" data-name="Group 45" transform="translate(-279.5 -608.5)"><line id="Line_4" data-name="Line 4" x2="10" transform="translate(287 609.5)" fill="none" stroke="#566779" stroke-linecap="round" stroke-width="2"/><line id="Line_5" data-name="Line 5" x2="18.5" transform="translate(280.5 616.5)" fill="none" stroke="#566779" stroke-linecap="round" stroke-width="2"/><line id="Line_6" data-name="Line 6" x2="12" transform="translate(281.5 623.5)" fill="none" stroke="#566779" stroke-linecap="round" stroke-width="2"/></g></svg>
			',

			// account icons
			'account-1' => '<svg width="100%" viewBox="0 0 100 70"><path d="M50 20c-8.2 0-15 6.8-15 15s6.8 15 15 15 15-6.8 15-15-6.8-15-15-15zm0 3c6.6 0 12 5.4 12 12 0 2.4-.8 4.7-1.9 6.5l-1.2-.9C56.6 38.8 52.2 38 50 38s-6.6.8-8.8 2.5l-1.2 1c-1.2-1.8-2-4-2-6.5 0-6.6 5.4-12 12-12zm0 2.7c-2.7 0-4.8 2.1-4.8 4.8s2.2 5 4.8 5 4.8-2.2 4.8-5-2.1-4.8-4.8-4.8zm0 2.8c1 0 1.8.9 1.8 1.8 0 1.1-.9 1.8-1.8 1.8s-1.8-.6-1.8-1.6.8-2 1.8-2zM50 41c4.7 0 7.2 1.8 8.2 2.7-2.1 2-5 3.3-8.2 3.3s-6.2-1.3-8.2-3.3c1-.9 3.5-2.7 8.2-2.7zm-8.8 2c.1.2.3.5.6.6-.3-.2-.5-.4-.6-.6zm17.6.1c-.2.1-.3.3-.5.6.2-.3.4-.5.5-.6z" fill="#566779"/></svg>
			',

			'account-2' => '<svg width="100%" viewBox="0 0 100 70"><path d="M47.4 20c-4.9 0-9.2 4-9.1 9.1v6.2c-.7.6-1.3 1.6-1.3 3 0 1.6.9 2.8 1.8 3.4.5.3.6.2.9.3 2 4.1 5.8 7.5 10.1 8.1h.4c4.3-.6 8.1-4 10.1-8.1.3-.1.5 0 .9-.3.9-.5 1.8-1.7 1.8-3.4 0-1.6-.9-2.8-1.8-3.4-.4-.2-.5-.2-.8-.2v-6.8c0-2.9-2.3-5.2-5.2-5.2h-1.3c0-.1-1.3-2.7-6.5-2.7zm3.2 10.4h3.3c2.1 0 3.8 1.7 3.9 3.8V37h1.5s.3 0 .6.2.5.3.5 1.1-.2.9-.5 1.1c-.3.2-.6.2-.6.2h-.8l-.3.7c-1.5 3.4-4.9 6.5-8.2 7-3.2-.5-6.7-3.5-8.2-7l-.3-.7h-.8s-.3 0-.6-.2-.5-.3-.5-1.1.2-.9.5-1.1c.3-.2.6-.2.6-.2h1.5v-4h3.9c1.9 0 3.6-1 4.5-2.6z" fill="#566779"/></svg>
			',

			'account-3' => '<svg width="100%" viewBox="0 0 100 70"><path d="M63.5 45.6v3c0 .8-.6 1.4-1.4 1.4-.8 0-1.4-.6-1.4-1.4v-3c0-2.6-2.1-4.7-4.7-4.7H43.9c-2.6 0-4.7 2.1-4.7 4.7v3c0 .8-.6 1.4-1.4 1.4s-1.4-.6-1.4-1.4v-3c0-4.1 3.3-7.4 7.4-7.4h12.1c4.3 0 7.6 3.3 7.6 7.4zM42.6 27.4c0-4.1 3.3-7.4 7.4-7.4s7.4 3.3 7.4 7.4c0 4.1-3.3 7.4-7.4 7.4s-7.4-3.3-7.4-7.4zm2.7 0c0 2.6 2.1 4.7 4.7 4.7s4.7-2.1 4.7-4.7-2.1-4.7-4.7-4.7-4.7 2.1-4.7 4.7z" fill="#566779"/></svg>
			',

			'account-4' => '<svg width="100%" viewBox="0 0 100 70"><path d="M50 20c-8.3 0-15 6.7-15 15s6.7 15 15 15 15-6.7 15-15-6.7-15-15-15zm0 4.1c2.7 0 4.9 2.2 4.9 4.9s-2.2 4.9-4.9 4.9-4.9-2.2-4.9-4.9 2.2-4.9 4.9-4.9zM50 47c-4.2 0-7.8-2.1-10-5.3 1.7-2.4 7-3.7 10-3.7s8.3 1.2 10 3.7c-2.2 3.2-5.8 5.3-10 5.3z" fill="#566779"/></svg>
			',

			'account-5' => '<svg width="100%" viewBox="0 0 100 70"><path d="M50 20c-8.3 0-15 6.7-15 15s6.7 15 15 15 15-6.7 15-15-6.7-15-15-15zm0 2.3c7 0 12.7 5.7 12.7 12.7 0 3.3-1.3 6.3-3.3 8.5-.9-1.6-3.4-2.9-6.1-3.5 0 0-1.3-.4-.7-1.6.8-1 1.3-2.2 1.3-2.5 0 0 1.1-.9 1.3-2.3.1-1.3-.3-1.4-.3-1.4.5-1.5.6-7.1-3-6.5-.6-1.2-4.4-2.1-6.1 1-.8 1.5-1.2 3.7-.4 5.3 0 .1-.2-.1-.4.7 0 .8.4 2 .7 2.4.1.2.3.4.6.5 0 0 .2 1.4 1.3 2.7.2 1-.8 1.6-.8 1.6-2.8.6-5.4 1.9-6.2 3.5-2-2.2-3.2-5.2-3.2-8.4-.1-7 5.6-12.7 12.6-12.7z" fill="#566779"/></svg>
			',

			'account-6' => '<svg width="100%" viewBox="0 0 100 70"><path d="M63.1 29.8l-12.3-9.5c-.5-.4-1.2-.4-1.7 0l-12.3 9.5c-.3.3-.5.7-.5 1.1v15c0 2.3 1.8 4.1 4.1 4.1h19.1c2.3 0 4.1-1.8 4.1-4.1v-15c0-.4-.2-.8-.5-1.1zM52.7 47.3h-5.5V36.4h5.5v10.9zm8.2-1.4c0 .8-.6 1.4-1.4 1.4h-4.1V35c0-.8-.6-1.4-1.4-1.4h-8.2c-.8 0-1.4.6-1.4 1.4v12.3h-4.1c-.8 0-1.4-.6-1.4-1.4V31.6L50 23.1l10.9 8.5v14.3z" fill="#566779"/></svg>
			',

			// Scroll to Top  icons
			'top-1' => '<svg xmlns="http://www.w3.org/2000/svg" width="15.666" height="18.898" viewBox="0 0 15.666 18.898"><g id="Group_5608" data-name="Group 5608" transform="translate(-1264.471 -499.965)"><path id="Path_26460" data-name="Path 26460" d="M-12476,4373.384l6.419-6.419,6.419,6.419" transform="translate(13741.885 -3866)"></path><path id="Path_26461" data-name="Path 26461" d="M-12469.8,4367.851v15.98" transform="translate(13742.106 -3865.969)"></path></g></svg>',

			'top-2' => '<svg xmlns="http://www.w3.org/2000/svg" width="14.506" height="21.055" viewBox="0 0 14.506 21.055"><g id="Group_5839" data-name="Group 5839" transform="translate(-1240.166 -2952.876)"><g id="Group_5837" data-name="Group 5837" transform="translate(1241.592 2958.591)"><path id="Path_26460" data-name="Path 26460" d="M-12476,4372.792l5.827-5.827,5.827,5.827" transform="translate(12476 -4366.965)"/><path id="Path_26461" data-name="Path 26461" d="M-12469.8,4367.851v14.507" transform="translate(12475.63 -4367.018)" /></g><path id="Path_26494" data-name="Path 26494" d="M0,0V14.506" transform="translate(1240.166 2953.876) rotate(-90)"/></g></svg>',

			'top-3' => '<svg xmlns="http://www.w3.org/2000/svg" width="13.068" height="14.775" viewBox="0 0 13.068 14.775"><g id="Group_5840" data-name="Group 5840" transform="translate(-1240.72 -2956.301)"><path id="Path_26460" data-name="Path 26460" d="M-12476,4372.792l5.827-5.827,5.827,5.827" transform="translate(13717.427 -1409.25)"/><path id="Path_26495" data-name="Path 26495" d="M-12476,4372.792l5.827-5.827,5.827,5.827" transform="translate(13717.427 -1402.423)"/></g></svg>',

			'top-4' => '<svg xmlns="http://www.w3.org/2000/svg" width="14.019" height="9.194" viewBox="0 0 14.019 9.194"><g id="Group_5840" data-name="Group 5840" transform="translate(-1238.427 -2958.715)"><path id="Path_26460" data-name="Path 26460" d="M-12476,4376.159l7.009-9.194,7.01,9.194" transform="translate(13714.426 -1408.249)"/></g></svg>',

			// Category Single Divider Icons
			'dot' => '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10"><circle id="Ellipse_1258" data-name="Ellipse 1258" cx="5" cy="5" r="5"/></svg>',

			'normal-slash' => '<svg xmlns="http://www.w3.org/2000/svg" width="11" height="2" viewBox="0 0 11 2"><rect id="Rectangle_1803" data-name="Rectangle 1803" width="11" height="2"/></svg>',

			'forward-slash' => '<svg xmlns="http://www.w3.org/2000/svg" width="2" height="17" viewBox="0 0 2 17"><rect id="Rectangle_1804" data-name="Rectangle 1804" width="17" height="2" transform="translate(0 17) rotate(-90)" /></svg>',

			'back-slash' => '<svg xmlns="http://www.w3.org/2000/svg" width="6.332" height="16.938" viewBox="0 0 6.332 16.938"><rect id="Rectangle_1805" data-name="Rectangle 1805" width="17" height="2" transform="matrix(0.259, -0.966, 0.966, 0.259, 0, 16.421)" /></svg>',


			//Button Icons
			'button-1' => '<svg width="100%" viewBox="0 0 100 70"><path d="M59.3,35c0,1.2-0.6,1.9-1.5,1.9c-0.9,0-1.5-0.7-1.5-1.9c0-1.1,0.6-1.9,1.5-1.9C58.7,33.1,59.3,33.8,59.3,35z M35.8,35.3h-1v1.6h1c0.6,0,1-0.3,1-0.8S36.4,35.3,35.8,35.3zM36.6,33.8c0-0.5-0.3-0.7-0.9-0.7h-1v1.5h0.8C36.2,34.5,36.6,34.2,36.6,33.8zM80,26.5v17c0,2.2-1.8,4-4,4H24c-2.2,0-4-1.8-4-4v-17c0-2.2,1.8-4,4-4h52C78.2,22.5,80,24.3,80,26.5z M38,36.2c0-0.7-0.6-1.3-1.3-1.4c0.6-0.1,1.1-0.6,1.1-1.2c0-0.9-0.7-1.4-1.7-1.4h-2.5v5.6h2.5C37.3,37.8,38,37.2,38,36.2z M43.8,32.2h-1.2v3.5c0,0.7-0.4,1.2-1.2,1.2c-0.8,0-1.2-0.5-1.2-1.2v-3.5H39v3.6c0,1.2,0.9,2.1,2.4,2.1c1.4,0,2.4-0.8,2.4-2.1V32.2z M49.3,32.2h-4.4v1h1.6v4.7h1.2v-4.7h1.6V32.2zM54.5,32.2h-4.4v1h1.6v4.7h1.2v-4.7h1.6V32.2z M60.5,35c0-1.8-1.1-2.9-2.7-2.9c-1.7,0-2.7,1.1-2.7,2.9s1,2.9,2.7,2.9S60.5,36.8,60.5,35z M66.4,32.2h-1.1v3.7l-2.6-3.7h-1v5.6h1.1v-3.7l2.6,3.7h1V32.2z"/></svg>
			',

			'button-2' => '<svg width="100%" viewBox="0 0 100 70"><path d="M76,24.5c1.1,0,2,0.9,2,2v17c0,1.1-0.9,2-2,2H24c-1.1,0-2-0.9-2-2v-17c0-1.1,0.9-2,2-2H76 M76,22.5H24c-2.2,0-4,1.8-4,4v17c0,2.2,1.8,4,4,4h52c2.2,0,4-1.8,4-4v-17C80,24.3,78.2,22.5,76,22.5L76,22.5zM36.7,34.8c0.6-0.1,1.1-0.6,1.1-1.3c0-0.9-0.7-1.4-1.7-1.4h-2.5v5.6h2.5c1.2,0,1.9-0.6,1.9-1.6C38,35.5,37.4,34.9,36.7,34.8z M35.7,33.1c0.6,0,0.9,0.3,0.9,0.7c0,0.5-0.4,0.8-1,0.8h-0.8v-1.5H35.7z M35.8,36.9h-1v-1.6h1c0.7,0,1.1,0.3,1.1,0.8C36.8,36.7,36.4,36.9,35.8,36.9zM42.6,32.2h1.2v3.6c0,1.2-0.9,2.1-2.4,2.1c-1.4,0-2.4-0.8-2.4-2.1v-3.6h1.2v3.5c0,0.7,0.4,1.2,1.2,1.2s1.2-0.5,1.2-1.2V32.2z M44.9,32.2h4.4v1h-1.6v4.7h-1.2v-4.7h-1.6C44.9,33.2,44.9,32.2,44.9,32.2zM50.1,32.2h4.4v1h-1.6v4.7h-1.2v-4.7h-1.6C50.1,33.2,50.1,32.2,50.1,32.2zM57.8,32.1c-1.7,0-2.7,1.1-2.7,2.9s1,2.9,2.7,2.9s2.7-1.1,2.7-2.9S59.5,32.1,57.8,32.1zM57.8,36.9c-0.9,0-1.5-0.7-1.5-1.9s0.6-1.9,1.5-1.9c0.9,0,1.5,0.8,1.5,1.9C59.3,36.2,58.7,36.9,57.8,36.9zM66.4,32.2v5.6h-1l-2.6-3.7l0,0v3.7h-1.1v-5.6h1l2.6,3.7l0,0v-3.7H66.4z"/></svg>
			',

			'norepeat' => '<svg viewBox="0 0 16 16"><rect x="6" y="6" width="4" height="4"/></svg>
			',

			'repeat' => '<svg viewBox="0 0 16 16"><path d="M0,0h4v4H0V0z M6,0h4v4H6V0z M12,0h4v4h-4V0z M0,6h4v4H0V6z M6,6h4v4H6V6z M12,6h4v4h-4V6z M0,12h4v4H0V12z M6,12h4v4H6V12zM12,12h4v4h-4V12z"/></svg>
			',

			'repeat_h' => '<svg viewBox="0 0 16 16"><rect y="6" width="4" height="4"/><rect x="6" y="6" width="4" height="4"/><rect x="12" y="6" width="4" height="4"/></svg>
			',

			'repeat_v' => '<svg viewBox="0 0 16 16"><rect x="6" width="4" height="4"/><rect x="6" y="6" width="4" height="4"/><rect x="6" y="12" width="4" height="4"/></svg>
			',

			// 2 columns layout
			'1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M24,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'2-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M32,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-2' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M16,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'3-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M34,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-3' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M14,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			// 3 columns layout
			'1-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M32,2h2v22h-2V2z M16,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-2-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M11,2h2v22h-2V2z M37,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'2-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M36,2h2v22h-2V2z M24,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-1-2' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M11,2h2v22h-2V2z M24,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			// 4 columns layout
			'1-1-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M12,2h2v22h-2V2z M24,2h2v22h-2V2z M36,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'2-1-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24z M18,2h2v22h-2V2z M28,2h2v22h-2V2z M38,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-1-1-2' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M1.9,26h46.2c1.1,0,1.9-0.9,1.9-2V2c0-1.1-0.9-2-1.9-2H1.9C0.9,0,0,0.9,0,2v22C0,25.1,0.9,26,1.9,26zM1.9,2h46.2v22H1.9V2zM11,24H9V2h2V24z M20,24h-2V2h2V24z M30,24h-2V2h2V24z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-2-2-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0z M48.1,24H1.9V2h46.2V24z M7.9,2h2v22h-2V2z M24,2h2v22h-2V2z M40.1,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			// 5 columns layout
			'1-1-1-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26" ><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24zM19.2,2h2v22h-2V2zM9.6,2h2v22h-2V2z M38.5,2h2v22h-2V2zM28.9,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'2-1-1-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24zM23.2,2h2v22h-2V2zM14.6,2h2v22h-2V2zM40.5,2h2v22h-2V2zM31.9,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-1-1-1-2' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M0,2l0,22c0,1.1,0.8,2,1.9,2h46.2c1,0,1.9-0.9,1.9-2V2c0-1.1-0.9-2-1.9-2L1.9,0C0.9,0,0,0.9,0,2zM1.9,2h46.2v22H1.9V2zM26.8,24h-2V2h2V24zM35.4,24h-2V2h2V24z M9.5,24h-2V2h2V24z M18.1,24h-2V2h2V24z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-1-2-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24zM15.1,2h2v22h-2V2zM7.5,2h2v22h-2V2z M40.5,2h2v22h-2V2z M32.9,2h2v22h-2V2z" fill="#566779" opacity="0.7"></svg>
			',

			// 6 columns layout
			'1-1-1-1-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24zM16,2h2v22h-2V2zM8,2h2v22H8V2z M24,2h2v22h-2V2z M32,2h2v22h-2V2zM40,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'2-1-1-1-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24zM20,2h2v22h-2V2zM13,2h2v22h-2V2z M27,2h2v22h-2V2z M34,2h2v22h-2V2zM41,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-1-1-1-1-2' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M0,2l0,22c0,1.1,0.8,2,1.9,2h46.2c1,0,1.9-0.9,1.9-2V2c0-1.1-0.9-2-1.9-2L1.9,0C0.9,0,0,0.9,0,2zM1.9,2h46.2v22H1.9V2zM30,24h-2V2h2V24zM37,24h-2V2h2V24z M23,24h-2V2h2V24z M16,24h-2V2h2V24zM9,24H7V2h2V24z" fill="#566779" opacity="0.7"/></svg>
			',

			'1-1-2-2-1-1' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v22c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V2C50,0.9,49.1,0,48.1,0zM48.1,24H1.9V2h46.2V24zM13.9,2h2v22h-2V2zM6.9,2h2v22h-2V2zM24,2h2v22h-2V2zM34,2h2v22h-2V2zM41,2h2v22h-2V2z" fill="#566779" opacity="0.7"/></svg>
			',


			'stacked' => '<svg width="50" height="26" viewBox="0 0 50 26"><path d="M48.1,0H1.9C0.9,0,0,0.9,0,2v10v2v10c0,1.1,0.9,2,1.9,2h46.2c1.1,0,1.9-0.9,1.9-2V14v-2V2C50,0.9,49.1,0,48.1,0z M48.1,24H1.9V14h46.2V24z M1.9,12V2h46.2v10H1.9z" fill="#566779" opacity="0.7"/></svg>
			',

			'breadcrumb-sep-1' => '<svg width="15" height="15" viewBox="0 0 20 20"><path d="M7.7,20c-0.3,0-0.5-0.1-0.7-0.3c-0.4-0.4-0.4-1.1,0-1.5l8.1-8.1L6.7,1.8c-0.4-0.4-0.4-1.1,0-1.5
			c0.4-0.4,1.1-0.4,1.5,0l9.1,9.1c0.4,0.4,0.4,1.1,0,1.5l-8.8,8.9C8.2,19.9,7.9,20,7.7,20z" opacity="0.7"/></svg>
			',

			'breadcrumb-sep-2' => '<svg width="15" height="15" viewBox="0 0 20 20"><polygon points="7,0 18,10 7,20 " opacity="0.7"/></svg>
			',

			'breadcrumb-sep-3' => '<svg width="15" height="15" viewBox="0 0 20 20"><path d="M6.1,20c-0.2,0-0.3,0-0.5-0.1c-0.5-0.2-0.7-0.8-0.4-1.3l9.5-17.9C15,0.1,15.6,0,16.1,0.2
			c0.5,0.2,0.7,0.8,0.4,1.3L6.9,19.4C6.8,19.8,6.5,19.9,6.1,20z" opacity="0.7"/></svg>
			',

			'filter-1' => '<svg width="100%" viewBox="0 0 100 70"><path d="M35.1 25.5c0-1.1.9-2 2.1-2H63c1.1 0 2 .9 2 2.1 0 1.1-.9 2-2.1 2H37.1 37c-1-.1-1.9-1-1.9-2.1zM62.9 33H37.1c-1.1 0-2 .9-2.1 2 0 1.1.9 2 2 2.1h25.8c1.1 0 2-.9 2.1-2 0-1.2-.9-2.1-2-2.1zm0 9.4H37.1c-1.1 0-2 .9-2.1 2 0 1.1.9 2 2 2.1h25.8c1.1 0 2-.9 2.1-2 0-1.1-.9-2-2-2.1z" fill="#566779" opacity="0.7"/></svg>
			',

			'filter-2' => '<svg width="100%" viewBox="0 0 100 70"><path d="M37.1 23.5c-1.1 0-2 .9-2.1 2 0 1.1.9 2 2 2.1h25.8c1.1 0 2-.9 2.1-2 0-1.1-.9-2-2-2.1H37.1zM39.9 33c-1.1 0-2 .9-2.1 2 0 1.1.9 2 2 2.1H60.2c1.1 0 2-.9 2.1-2 0-1.1-.9-2-2-2.1H39.9zM42.6 42.4c-1.1 0-2 .9-2.1 2 0 1.1.9 2 2 2.1h15c1.1 0 2-.9 2.1-2 0-1.1-.9-2-2-2.1h-15z" fill="#566779" opacity="0.7"/></svg>
			',

			'filter-3' => '<svg width="100%" viewBox="0 0 100 70"><path d="M61.5 25.8v2.3H50.9c-.5 1.3-1.7 2.3-3.2 2.3-1.5 0-2.8-1-3.2-2.3h-6v-2.3h6c.5-1.3 1.7-2.3 3.2-2.3 1.5 0 2.8 1 3.2 2.3h10.6zm-8 5.7c-1.5 0-2.8 1-3.2 2.3H38.5v2.3h11.7c.5 1.3 1.7 2.3 3.2 2.3 1.5 0 2.8-1 3.2-2.3h4.8v-2.3h-4.8c-.4-1.3-1.7-2.3-3.1-2.3zm-9.3 8.1c-1.5 0-2.8 1-3.2 2.3h-2.5v2.3H41c.5 1.3 1.7 2.3 3.2 2.3 1.5 0 2.8-1 3.2-2.3h14v-2.3h-14c-.4-1.3-1.7-2.3-3.2-2.3z" fill="#566779" opacity="0.7"/></svg>
			',

			'filter-4' => '<svg width="100%" viewBox="0 0 100 70"><path d="M52.3 46.5c-.2 0-.4 0-.5-.1l-4.6-2.3c-.4-.2-.6-.6-.6-1V36l-8.9-10.6c-.3-.3-.4-.8-.2-1.2.2-.4.6-.7 1-.7h23c.4 0 .9.3 1 .7.2.4.1.9-.2 1.2L53.4 36v9.4c0 .4-.2.8-.5 1-.2 0-.4.1-.6.1z" fill="#566779" opacity="0.7"/></svg>
			',
		];

		if (!isset($svgs[$path])) {
			return '';
		}

		return $svgs[$path];
	}
}
